//PARENT OR SUPER CLASS

class Building{
    constructor(address,yearBuilt){
        this.address = address;
        this.yearBuilt = yearBuilt;
    }
}

//EXTEND THE PARENT WITH PARKING SUBCLASS
class Parking extends Building{

    constructor(address,yearBuilt,size,fullSpots,hourlySpots,priceHourly,fullDayPrice){
        super(address,yearBuilt);
        this.size = size;
        this.fullSpots = fullSpots;
        this.hourlySpots = hourlySpots;
        this.priceHourly = priceHourly;
        this.fullDayPrice = fullDayPrice;
    }

}

//EXTEND THE PARENT WITH CLINICS SUBCLASS
class Clinic extends Building{
    constructor(address,yearBuilt,dailyPatients,size = 2){
        super(address,yearBuilt);
        this.dailyPatients = dailyPatients;
        this.size = size;
    } 
    //HASHMAP
    buildingClassification(){
        const clinicSize = new Map();
        clinicSize.set(1,'small');
        clinicSize.set(2,'normal');
        clinicSize.set(3,'big');
        console.log(`${this.address}, was built in ${this.yearBuilt}, is a ${clinicSize.get(this.size)} clinic.`);
    }
    //METHOD FOR CALCULATING THE PATIENTS
    //as it is in the final file
    calcPatients(arr){
        let thePatients = 0;
        arr.forEach(element =>{
            thePatients += element[0];
        });
        console.log(`1. In all of the clinics we have an average of: ${thePatients/arr.length} patients per day`);
        console.log(`2. In all of the clinics we have total of: ${thePatients} patients per day`);
        console.log(`3. The total income per day for all of the patient visits is: $${thePatients*50}.`);
        console.log(`4. The average income per day for all of the patient visits is: $${(thePatients/arr.length)*50}.`);
    }
    //Modified version
    calcPatientsModified(arr){
        let thePatients = 0;
        arr.forEach(element =>{
            thePatients += element;
        });
        console.log(`1. In all of the clinics we have an average of: ${thePatients/arr.length} patients per day`);
        console.log(`2. In all of the clinics we have total of: ${thePatients} patients per day`);
        console.log(`3. The total income per day for all of the patient visits is: $${thePatients*50}.`);
        console.log(`4. The average income per day for all of the patient visits is: $${(thePatients/arr.length)*50}.`);
    }
}
//THIS WILL RETURN THE NEWEST AND OLDEST YEAR OR MIN MAX VALUE
function getMinMax(data){
    //SPREAD OPERATOR
    const min = Math.min(...data);
    const max = Math.max(...data);
    return [min,max];
}
//THIS WILL BE THE FN FOR CALC THE PARKINGS DATA
function calc(data){
    let fullParking = 0, fullHourly = 0, fullIncome = 0, hourlyIncome = 0; 
    data.forEach(element =>{
    fullParking += element[0];
    fullHourly += element[1];
    fullIncome += element[0] * element[3];
    hourlyIncome += element[1]*element[2];    
    });
    //RETURN [AVG FULL PARKING,AVG HOURLY PARKING,T.F PARKINGS SP,T.H PARKINGS SP, FULL INCOME, HOURLY INC]
    return [fullParking / data.length, fullHourly / data.length, fullParking, fullHourly, fullIncome, hourlyIncome];
}

//DATA FOR CLINICS 
const allClinics = [new Clinic('Swanson Street Level 2',2016,105,3),
                    new Clinic('Brighton Street',2019,172,3),
                    new Clinic('Docklands Street Shop 4-51',2020,33,1),
                    new Clinic('Southbank Street Level 5',2016,66,2)];
//DATA FOR PARKINGS
const allParkings = [new Parking('Swanson Street',2016,150,90,60,3,9),
                    new Parking('Brighton Street',2019,120,100,20,3,9),
                    new Parking('Docklands Street',2020,180,80,100,3,9),
                    new Parking('Southbank Street',2016,160,76,84,3,9)];


//THIS WILL BE FN FOR CLINICS WHERE WE PASS THE ARRAY DATA
function clinicsReport(clinics){
console.log('/////////// CLINICS REPORT ///////////');

let clinic = new Clinic();
// const patients = clinics.map(curr => [curr.dailyPatients]);
// clinic.calcPatients(patients);

//modified version
const patients = clinics.map(curr => curr.dailyPatients);
clinic.calcPatientsModified(patients);


//DESTRUCTURING
const yearDetails = clinics.map(curr => curr.yearBuilt);
const [newBuilt,oldBuilt] = getMinMax(yearDetails);
console.log(`5. The newest dental clinic was opened in the year ${newBuilt}`);
console.log(`6. The oldest dental clinic was opened in the year ${oldBuilt}`);

//DESTRUCTURING
//const clinicPatients = clinics.map(curr => curr.dailyPatients);
const [min,max] = getMinMax(patients);
console.log(`7. The smallest number of patients in one day was: ${min}`);
console.log(`8. The largest number of patients in one day was ${max}`);
//CLINIC SIZE
clinics.forEach(curr => curr.buildingClassification());
}


//THIS WILL BE FN FOR PARKINGS WHERE WE PASS THE ARRAY DATA
function parkingsReport(parkings){
    console.log('/////////// PARKINGS REPORT ///////////');
    const parkingData = parkings.map(curr => [curr.fullSpots,curr.hourlySpots,curr.priceHourly,curr.fullDayPrice]);
    //DESTRUCTURING
    const [fullParkingAVG,hourlyParkingAVG,
        totalParkingSpots,totalHParkingSpots,
        totalPIncome,totalHPIncome] = calc(parkingData);
        console.log(`1. In our ${parkings.length} dental clinics we have approximately an average 
        of ${fullParkingAVG} all day parking spots`);
        console.log(`2. In our ${parkings.length} dental clinics we have approximately an average 
        of ${hourlyParkingAVG} hourly parking spots`);
        console.log(`3. In all of the ${parkings.length} dental clinics we have total number 
        of all day parking spots ${totalParkingSpots} per day`);
        console.log(`4. In all of the ${parkings.length} dental clinics we have total number 
        of hourly parking spots ${totalHParkingSpots} per day`)
        console.log(`5. All day parking income from all ${parkings.length} clinics is $${totalPIncome} per day`);
        console.log(`6. Hourly parking income from all ${parkings.length} clinics is $${totalHPIncome} per day`);
        //FINDING THE PARKING THAT HAS MORE THAN A 100 HOURLY OR ALL DAYS SPOTS
        const indexF = parkings.map(el => el.fullSpots).findIndex(el => el>=100);
        console.log(`7. ${parkings[indexF].address} has more than or equal to a 100 all day parking spots`);
        const indexH = parkings.map(el =>el.hourlySpots).findIndex(el => el>=100);
        console.log(`8. ${parkings[indexH].address} has more than or equal to a 100 all day parking spots`);
}

//CALL THE REPORTS FN HERE
clinicsReport(allClinics);
parkingsReport(allParkings);
